import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { JwtModule } from '@nestjs/jwt';
import { UsersController } from './users.controller';
import { UsersService } from './users.service';
import { User } from './entities/user.entity';
import { UserActivity } from '../user-activity/entities/user-activity.entity';
import { Login } from '../login/entities/login.entity';
import { PermissionsModule } from '../permissions/permissions.module';
import { PermissionsGuard } from '../auth/guards/permissions.guard';
import { EmailService } from '../common/services/email.service';

@Module({
  imports: [
    TypeOrmModule.forFeature([User, UserActivity, Login]),
    PermissionsModule,
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'your-secret-key',
      signOptions: { expiresIn: '1h' },
    }),
  ],
  controllers: [UsersController],
  providers: [UsersService, EmailService, PermissionsGuard],
  exports: [UsersService, TypeOrmModule],
})
export class UsersModule {}