import { IsString, IsNotEmpty, IsOptional, IsNumber, Min } from 'class-validator';
import { Transform, Type } from 'class-transformer';

export class CreateProductDto {
  @IsString()
  @IsNotEmpty({ message: 'Product name is required' })
  @Transform(({ value }) => value.trim())
  name: string;

  @IsString()
  @IsOptional()
  @Transform(({ value }) => value?.trim())
  description?: string;

  @IsNumber()
  @IsOptional()
  @Min(0, { message: 'Amount must be greater than or equal to 0' })
  @Type(() => Number)
  amount?: number;

  @IsNumber()
  @IsOptional()
  @Min(0, { message: 'Postage/Service charges must be greater than or equal to 0' })
  @Type(() => Number)
  postageServiceCharges?: number;
}


