import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  HttpStatus,
  UseGuards,
} from '@nestjs/common';
import { PostageServiceChargesService } from './postage-service-charges.service';
import { CreatePostageServiceChargeDto } from './dto/create-postage-service-charge.dto';
import { UpdatePostageServiceChargeDto } from './dto/update-postage-service-charge.dto';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { PermissionsGuard } from '../auth/guards/permissions.guard';
import { RolesGuard } from '../auth/guards/roles.guard';

@Controller('api/postage-service-charges')
@UseGuards(JwtAuthGuard, PermissionsGuard, RolesGuard)
export class PostageServiceChargesController {
  constructor(private readonly postageServiceChargesService: PostageServiceChargesService) {}

  @Post()
  async create(@Body() createDto: CreatePostageServiceChargeDto) {
    const charge = await this.postageServiceChargesService.create(createDto);
    return {
      statusCode: HttpStatus.CREATED,
      message: 'Postage/Service charge created successfully',
      data: charge,
    };
  }

  @Get()
  async findAll() {
    const charges = await this.postageServiceChargesService.findAll();
    return {
      statusCode: HttpStatus.OK,
      message: 'Postage/Service charges retrieved successfully',
      data: charges,
    };
  }

  @Get('all')
  async findAllIncludingInactive() {
    const charges = await this.postageServiceChargesService.findAllIncludingInactive();
    return {
      statusCode: HttpStatus.OK,
      message: 'All postage/service charges retrieved successfully',
      data: charges,
    };
  }

  @Get(':id')
  async findOne(@Param('id') id: string) {
    const charge = await this.postageServiceChargesService.findOne(+id);
    return {
      statusCode: HttpStatus.OK,
      message: 'Postage/Service charge retrieved successfully',
      data: charge,
    };
  }

  @Patch(':id')
  async update(@Param('id') id: string, @Body() updateDto: UpdatePostageServiceChargeDto) {
    const charge = await this.postageServiceChargesService.update(+id, updateDto);
    return {
      statusCode: HttpStatus.OK,
      message: 'Postage/Service charge updated successfully',
      data: charge,
    };
  }

  @Delete(':id')
  async remove(@Param('id') id: string) {
    await this.postageServiceChargesService.remove(+id);
    return {
      statusCode: HttpStatus.OK,
      message: 'Postage/Service charge deleted successfully',
    };
  }
}


