import { IsInt, IsOptional, IsArray, ValidateNested, IsBoolean, IsDateString } from 'class-validator';
import { Type } from 'class-transformer';
import { UpdateOrderItemDto } from './update-order-item.dto';

export class UpdateOrderDto {
  @IsInt()
  @IsOptional()
  @Type(() => Number)
  customerId?: number;

  @IsArray()
  @IsOptional()
  @ValidateNested({ each: true })
  @Type(() => UpdateOrderItemDto)
  orderItems?: UpdateOrderItemDto[];

  @IsDateString()
  @IsOptional()
  orderDate?: string;

  @IsBoolean()
  @IsOptional()
  isActive?: boolean;
}


