import { IsInt, IsNotEmpty, IsArray, ValidateNested, ArrayMinSize, IsDateString, IsOptional } from 'class-validator';
import { Type } from 'class-transformer';
import { CreateOrderItemDto } from './create-order-item.dto';

export class CreateOrderDto {
  @IsInt()
  @IsNotEmpty({ message: 'Customer ID is required' })
  @Type(() => Number)
  customerId: number;

  @IsArray()
  @ArrayMinSize(1, { message: 'At least one order item is required' })
  @ValidateNested({ each: true })
  @Type(() => CreateOrderItemDto)
  orderItems: CreateOrderItemDto[];

  @IsDateString()
  @IsOptional()
  orderDate?: string;
}


