import { IsInt, IsNotEmpty, Min, IsNumber, IsOptional, IsString } from 'class-validator';
import { Type } from 'class-transformer';

export class CreateOrderItemDto {
  @IsInt()
  @IsNotEmpty({ message: 'Product ID is required' })
  @Type(() => Number)
  productId: number;

  @IsInt()
  @IsNotEmpty({ message: 'Count is required' })
  @Min(1, { message: 'Count must be at least 1' })
  @Type(() => Number)
  count: number;

  @IsNumber()
  @IsNotEmpty({ message: 'Amount per tub is required' })
  @Min(0, { message: 'Amount per tub must be greater than or equal to 0'})
  @Type(() => Number)
  amountPerTub: number;

  @IsNumber()
  @IsNotEmpty({ message: 'Total amount is required'})
  @Min(0, { message: 'Total amount must be greater than or equal to 0'})
  @Type(() => Number)
  totalAmount: number;

  @IsInt()
  @IsOptional()
  @Type(() => Number)
  postageServiceChargeId?: number;

  @IsString()
  @IsOptional()
  deductionNote?: string;
}


