import { Entity, Column, PrimaryGeneratedColumn, CreateDateColumn, UpdateDateColumn, ManyToOne, JoinColumn, OneToMany } from 'typeorm';
import { User } from '../../users/entities/user.entity';
import { Address } from './address.entity';

@Entity('customers')
export class Customer {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ nullable: false })
  firstName: string;

  @Column({ nullable: false })
  lastName: string;

  @Column({ nullable: true, unique: true })
  email: string;

  @Column({ nullable: true })
  mobileNumber: string;

  @Column({ nullable: true })
  landline: string;

  @OneToMany(() => Address, (address) => address.customer, { cascade: true })
  addresses: Address[];

  @Column({ nullable: true })
  title: string;

  @Column({ nullable: true })
  iso: string;

  @Column({ type: 'boolean', default: false })
  dnc: boolean;

  @Column({ type: 'boolean', default: true })
  isLandLineDefault: boolean;

  @CreateDateColumn({ name: 'created_at' })
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ default: true })
  isActive: boolean;

  @Column({ nullable: true })
  customerId: string;

  @Column({ unique: true, nullable: true })
  genCustomerId: string;

  @Column({ nullable: true })
  assigned_to_id: number | null;

  @ManyToOne(() => User)
  @JoinColumn({ name: 'assigned_to_id' })
  assignedTo: User;

  @Column({ nullable: true })
  createdById: number;

  @OneToMany('Order', 'customer')
  orders: any[];

}