import {
  Entity, Column, PrimaryGeneratedColumn,
  ManyToOne, CreateDateColumn, UpdateDateColumn
} from 'typeorm';
import { Customer } from './customer.entity';
import { User } from '../../users/entities/user.entity';

@Entity('customer_notes')
export class CustomerNote {
  @PrimaryGeneratedColumn()
  id: number;

  @CreateDateColumn({ name: 'created_at' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at' })
  updatedAt: Date;

  @Column({ default: true })
  isActive: boolean;

  @Column()
  note: string;

  @ManyToOne(() => CustomerNote, { nullable: true, onDelete: 'SET NULL' })
  childNote: CustomerNote | null;

  @ManyToOne(() => User, { nullable: true })
  createdBy: User | null;

  @ManyToOne(() => Customer, { onDelete: 'CASCADE' })
  customer: Customer;

  @ManyToOne(() => CustomerNote, { nullable: true, onDelete: 'SET NULL' })
  parentNote: CustomerNote | null;
}
