"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var RolesService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RolesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const role_entity_1 = require("./entities/role.entity");
const permissions_service_1 = require("../permissions/permissions.service");
let RolesService = RolesService_1 = class RolesService {
    roleRepository;
    permissionsService;
    logger = new common_1.Logger(RolesService_1.name);
    constructor(roleRepository, permissionsService) {
        this.roleRepository = roleRepository;
        this.permissionsService = permissionsService;
    }
    async findAll() {
        try {
            this.logger.debug('findAll() - Starting to fetch all roles');
            const roles = await this.roleRepository.find();
            this.logger.debug(`findAll() - Found ${roles.length} roles in database`);
            if (roles.length === 0) {
                this.logger.warn('findAll() - No roles found in database');
                return {
                    data: [],
                    success: true,
                    message: 'List Successfully Retrieved!',
                    status: 200
                };
            }
            this.logger.debug('findAll() - Fetching permissions for each role');
            const rolesWithPermissions = await Promise.all(roles.map(async (role) => {
                try {
                    this.logger.debug(`findAll() - Fetching permissions for role ID: ${role.id}, name: ${role.name}`);
                    const permissionsResponse = await this.permissionsService.findAll(role.id.toString());
                    this.logger.debug(`findAll() - Found ${permissionsResponse.data?.length || 0} permissions for role ID: ${role.id}`);
                    return {
                        id: role.id,
                        name: role.name,
                        permissions: permissionsResponse.data
                    };
                }
                catch (error) {
                    this.logger.error(`findAll() - Error fetching permissions for role ID ${role.id}: ${error.message}`, error.stack);
                    return {
                        id: role.id,
                        name: role.name,
                        permissions: []
                    };
                }
            }));
            this.logger.log(`findAll() - Successfully retrieved ${rolesWithPermissions.length} roles with permissions`);
            return {
                data: rolesWithPermissions,
                success: true,
                message: 'List Successfully Retrieved!',
                status: 200
            };
        }
        catch (error) {
            this.logger.error(`findAll() - Error fetching roles: ${error.message}`, error.stack);
            throw error;
        }
    }
    async findOne(id) {
        try {
            this.logger.debug(`findOne() - Searching for role with ID: ${id}`);
            const role = await this.roleRepository.findOne({ where: { id } });
            if (!role) {
                this.logger.warn(`findOne() - Role with ID ${id} not found`);
                throw new common_1.NotFoundException(`Role with ID ${id} not found`);
            }
            this.logger.log(`findOne() - Successfully found role with ID: ${id}, name: ${role.name}`);
            return role;
        }
        catch (error) {
            if (error instanceof common_1.NotFoundException) {
                throw error;
            }
            this.logger.error(`findOne() - Error finding role with ID ${id}: ${error.message}`, error.stack);
            throw error;
        }
    }
};
exports.RolesService = RolesService;
exports.RolesService = RolesService = RolesService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(role_entity_1.Role)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        permissions_service_1.PermissionsService])
], RolesService);
//# sourceMappingURL=roles.service.js.map