"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ProductsController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsController = void 0;
const common_1 = require("@nestjs/common");
const products_service_1 = require("./products.service");
const create_product_dto_1 = require("./dto/create-product.dto");
const update_product_dto_1 = require("./dto/update-product.dto");
const list_products_dto_1 = require("./dto/list-products.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_guard_1 = require("../auth/guards/roles.guard");
let ProductsController = ProductsController_1 = class ProductsController {
    productsService;
    logger = new common_1.Logger(ProductsController_1.name);
    constructor(productsService) {
        this.productsService = productsService;
    }
    async create(createProductDto) {
        try {
            this.logger.debug(`POST /api/products - Creating product with name: ${createProductDto.name}`);
            const product = await this.productsService.create(createProductDto);
            this.logger.log(`POST /api/products - Successfully created product with ID: ${product.id}, name: ${product.name}`);
            return {
                statusCode: common_1.HttpStatus.CREATED,
                message: 'Product created successfully',
                data: product,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`POST /api/products - Error creating product. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async findAll(listProductsDto) {
        try {
            this.logger.debug(`GET /api/products - Finding products with filters: ${JSON.stringify(listProductsDto)}`);
            const { data, total } = await this.productsService.findAll(listProductsDto);
            this.logger.log(`GET /api/products - Successfully retrieved ${data.length} products (total: ${total})`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Products retrieved successfully',
                data,
                total,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`GET /api/products - Error finding products. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async findOne(id) {
        try {
            const productId = +id;
            this.logger.debug(`GET /api/products/${id} - Finding product with ID: ${productId}`);
            const product = await this.productsService.findOne(productId);
            this.logger.log(`GET /api/products/${id} - Successfully retrieved product: ${product.name}`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Product retrieved successfully',
                data: product,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`GET /api/products/${id} - Error finding product. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async update(id, updateProductDto) {
        try {
            const productId = +id;
            this.logger.debug(`PATCH /api/products/${id} - Updating product with ID: ${productId}, data: ${JSON.stringify(updateProductDto)}`);
            const product = await this.productsService.update(productId, updateProductDto);
            this.logger.log(`PATCH /api/products/${id} - Successfully updated product: ${product.name}`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Product updated successfully',
                data: product,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`PATCH /api/products/${id} - Error updating product. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async remove(id) {
        try {
            const productId = +id;
            this.logger.debug(`DELETE /api/products/${id} - Deleting product with ID: ${productId}`);
            await this.productsService.remove(productId);
            this.logger.log(`DELETE /api/products/${id} - Successfully deleted product`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Product deleted successfully',
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`DELETE /api/products/${id} - Error deleting product. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
};
exports.ProductsController = ProductsController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_product_dto_1.CreateProductDto]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [list_products_dto_1.ListProductsDto]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_product_dto_1.UpdateProductDto]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "remove", null);
exports.ProductsController = ProductsController = ProductsController_1 = __decorate([
    (0, common_1.Controller)('api/products'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, permissions_guard_1.PermissionsGuard, roles_guard_1.RolesGuard),
    __metadata("design:paramtypes", [products_service_1.ProductsService])
], ProductsController);
//# sourceMappingURL=products.controller.js.map