export interface Permission {
    id: number;
    category: string;
    entity: string;
    action: string;
    role: string;
    role_name: string;
    createdAt: Date;
    updatedAt: Date;
}
export interface PermissionResponse {
    id: number;
    name: string;
    codename: string;
    content_type: number;
}
export interface PermissionsResponse {
    data: PermissionResponse[];
    success: boolean;
    message: string;
    status: number;
}
export interface PermissionCategory {
    name: string;
    entities: {
        name: string;
        actions: string[];
    }[];
}
export declare const PERMISSION_CATEGORIES: PermissionCategory[];
