"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersModule = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const orders_service_1 = require("./orders.service");
const orders_controller_1 = require("./orders.controller");
const postage_service_charges_service_1 = require("./postage-service-charges.service");
const postage_service_charges_controller_1 = require("./postage-service-charges.controller");
const order_entity_1 = require("./entities/order.entity");
const order_item_entity_1 = require("./entities/order-item.entity");
const postage_service_charge_entity_1 = require("./entities/postage-service-charge.entity");
const customer_entity_1 = require("../customers/entities/customer.entity");
const product_entity_1 = require("../products/entities/product.entity");
const user_entity_1 = require("../users/entities/user.entity");
const customers_module_1 = require("../customers/customers.module");
const products_module_1 = require("../products/products.module");
let OrdersModule = class OrdersModule {
    ordersService;
    constructor(ordersService) {
        this.ordersService = ordersService;
    }
    async onModuleInit() {
        try {
            await this.ordersService.cleanupInvalidOrders();
        }
        catch (error) {
            console.warn('Failed to cleanup invalid orders on module init:', error.message);
        }
    }
};
exports.OrdersModule = OrdersModule;
exports.OrdersModule = OrdersModule = __decorate([
    (0, common_1.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forFeature([order_entity_1.Order, order_item_entity_1.OrderItem, postage_service_charge_entity_1.PostageServiceCharge, customer_entity_1.Customer, product_entity_1.Product, user_entity_1.User]),
            customers_module_1.CustomersModule,
            products_module_1.ProductsModule,
        ],
        controllers: [orders_controller_1.OrdersController, postage_service_charges_controller_1.PostageServiceChargesController],
        providers: [orders_service_1.OrdersService, postage_service_charges_service_1.PostageServiceChargesService],
        exports: [orders_service_1.OrdersService, postage_service_charges_service_1.PostageServiceChargesService],
    }),
    __metadata("design:paramtypes", [orders_service_1.OrdersService])
], OrdersModule);
//# sourceMappingURL=orders.module.js.map