"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var OrdersController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersController = void 0;
const common_1 = require("@nestjs/common");
const orders_service_1 = require("./orders.service");
const create_order_dto_1 = require("./dto/create-order.dto");
const update_order_dto_1 = require("./dto/update-order.dto");
const list_orders_dto_1 = require("./dto/list-orders.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_guard_1 = require("../auth/guards/roles.guard");
const user_decorator_1 = require("../auth/decorators/user.decorator");
let OrdersController = OrdersController_1 = class OrdersController {
    ordersService;
    logger = new common_1.Logger(OrdersController_1.name);
    constructor(ordersService) {
        this.ordersService = ordersService;
    }
    async create(createOrderDto, user) {
        try {
            this.logger.debug(`POST /api/orders - Creating order for customer ID: ${createOrderDto.customerId}, user ID: ${user.id}`);
            const order = await this.ordersService.create(createOrderDto, user);
            this.logger.log(`POST /api/orders - Successfully created order with ID: ${order.id}, orderNumber: ${order.orderNumber}`);
            return {
                statusCode: common_1.HttpStatus.CREATED,
                message: 'Order created successfully',
                data: order,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`POST /api/orders - Error creating order. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async findAll(listOrdersDto, user) {
        try {
            this.logger.debug(`GET /api/orders - Finding orders with filters: ${JSON.stringify(listOrdersDto)}, user ID: ${user.id}`);
            const { data, total } = await this.ordersService.findAll(listOrdersDto, user);
            this.logger.log(`GET /api/orders - Successfully retrieved ${data.length} orders (total: ${total})`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Orders retrieved successfully',
                data,
                total,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`GET /api/orders - Error finding orders. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async findOne(id, user) {
        try {
            const orderId = +id;
            this.logger.debug(`GET /api/orders/${id} - Finding order with ID: ${orderId}, user ID: ${user.id}`);
            const order = await this.ordersService.findOne(orderId, user);
            this.logger.log(`GET /api/orders/${id} - Successfully retrieved order: ${order.orderNumber}`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Order retrieved successfully',
                data: order,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`GET /api/orders/${id} - Error finding order. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async update(id, updateOrderDto, user) {
        try {
            const orderId = +id;
            this.logger.debug(`PATCH /api/orders/${id} - Updating order with ID: ${orderId}, user ID: ${user.id}, data: ${JSON.stringify(updateOrderDto)}`);
            const order = await this.ordersService.update(orderId, updateOrderDto, user);
            this.logger.log(`PATCH /api/orders/${id} - Successfully updated order: ${order.orderNumber}`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Order updated successfully',
                data: order,
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`PATCH /api/orders/${id} - Error updating order. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
    async remove(id, user) {
        try {
            const orderId = +id;
            this.logger.debug(`DELETE /api/orders/${id} - Deleting order with ID: ${orderId}, user ID: ${user.id}`);
            await this.ordersService.remove(orderId, user);
            this.logger.log(`DELETE /api/orders/${id} - Successfully deleted order`);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Order deleted successfully',
            };
        }
        catch (error) {
            const errorType = error.constructor.name;
            const errorMessage = error.message || 'Unknown error';
            this.logger.error(`DELETE /api/orders/${id} - Error deleting order. Error Type: ${errorType}, Message: ${errorMessage}`, error.stack);
            throw error;
        }
    }
};
exports.OrdersController = OrdersController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_order_dto_1.CreateOrderDto, Object]),
    __metadata("design:returntype", Promise)
], OrdersController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [list_orders_dto_1.ListOrdersDto, Object]),
    __metadata("design:returntype", Promise)
], OrdersController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], OrdersController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_order_dto_1.UpdateOrderDto, Object]),
    __metadata("design:returntype", Promise)
], OrdersController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], OrdersController.prototype, "remove", null);
exports.OrdersController = OrdersController = OrdersController_1 = __decorate([
    (0, common_1.Controller)('api/orders'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, permissions_guard_1.PermissionsGuard, roles_guard_1.RolesGuard),
    __metadata("design:paramtypes", [orders_service_1.OrdersService])
], OrdersController);
//# sourceMappingURL=orders.controller.js.map