import { HttpStatus } from '@nestjs/common';
import { OrdersService } from './orders.service';
import { CreateOrderDto } from './dto/create-order.dto';
import { UpdateOrderDto } from './dto/update-order.dto';
import { ListOrdersDto } from './dto/list-orders.dto';
export declare class OrdersController {
    private readonly ordersService;
    private readonly logger;
    constructor(ordersService: OrdersService);
    create(createOrderDto: CreateOrderDto, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/order.entity").Order;
    }>;
    findAll(listOrdersDto: ListOrdersDto, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/order.entity").Order[];
        total: number;
    }>;
    findOne(id: string, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/order.entity").Order;
    }>;
    update(id: string, updateOrderDto: UpdateOrderDto, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/order.entity").Order;
    }>;
    remove(id: string, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
    }>;
}
