"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const login_entity_1 = require("./entities/login.entity");
const user_entity_1 = require("../users/entities/user.entity");
const email_service_1 = require("../common/services/email.service");
const jwt_1 = require("@nestjs/jwt");
const user_activity_service_1 = require("../user-activity/user-activity.service");
const permissions_service_1 = require("../permissions/permissions.service");
let LoginService = class LoginService {
    loginRepository;
    userRepository;
    emailService;
    jwtService;
    userActivityService;
    permissionsService;
    constructor(loginRepository, userRepository, emailService, jwtService, userActivityService, permissionsService) {
        this.loginRepository = loginRepository;
        this.userRepository = userRepository;
        this.emailService = emailService;
        this.jwtService = jwtService;
        this.userActivityService = userActivityService;
        this.permissionsService = permissionsService;
    }
    getClientIp(request) {
        const forwarded = request.headers['x-forwarded-for'];
        if (typeof forwarded === 'string')
            return forwarded.split(',')[0].trim();
        const ip = request.socket?.remoteAddress ||
            request.connection?.remoteAddress ||
            request.ip ||
            'unknown';
        if (ip === '::1' || ip === '127.0.0.1')
            return '127.0.0.1';
        if (ip.startsWith('::ffff:'))
            return ip.replace('::ffff:', '');
        return ip;
    }
    async requestOTP(email, request) {
        const user = await this.userRepository.findOne({ where: { email } });
        if (!user) {
            await this.loginRepository.save({
                email,
                status: 'failed',
                failureReason: 'Invalid Email',
                ipAddress: this.getClientIp(request),
            });
            throw new common_1.NotFoundException('Invalid Email');
        }
        const otp = Math.floor(10000 + Math.random() * 90000).toString();
        const otpExpiresAt = new Date();
        otpExpiresAt.setMinutes(otpExpiresAt.getMinutes() + 5);
        const loginAttempt = await this.loginRepository.save({
            email,
            otp,
            otpExpiresAt,
            isVerified: false,
            status: 'pending',
            ipAddress: this.getClientIp(request),
            user,
        });
        try {
            await this.emailService.sendOTP(email, otp);
        }
        catch (error) {
            await this.loginRepository.update(loginAttempt.id, {
                status: 'failed',
                failureReason: 'Failed to send OTP email',
            });
            console.error('Failed to send OTP email:', error);
            const nodeError = error;
            if (nodeError.code === 'EAI_AGAIN' || nodeError.code === 'ENOTFOUND' || nodeError.code === 'EDNS') {
                throw new Error('Email server configuration error. Please contact administrator.');
            }
            throw new Error('Failed to send OTP email');
        }
        return { message: 'OTP sent successfully' };
    }
    async verifyOTP(email, otp, request) {
        const loginAttempt = await this.loginRepository.findOne({
            where: { email, otp },
            order: { createdAt: 'DESC' },
        });
        if (!loginAttempt) {
            await this.loginRepository.save({
                email,
                status: 'failed',
                failureReason: 'Invalid OTP',
                ipAddress: this.getClientIp(request),
            });
            throw new common_1.UnauthorizedException('Invalid OTP');
        }
        if (loginAttempt.otpExpiresAt < new Date()) {
            await this.loginRepository.update(loginAttempt.id, {
                status: 'failed',
                failureReason: 'OTP expired',
            });
            throw new common_1.UnauthorizedException('OTP has expired');
        }
        if (loginAttempt.isVerified) {
            await this.loginRepository.update(loginAttempt.id, {
                status: 'failed',
                failureReason: 'OTP already used',
            });
            throw new common_1.UnauthorizedException('OTP already used');
        }
        await this.loginRepository.update(loginAttempt.id, {
            isVerified: true,
            status: 'success',
            verifiedAt: new Date(),
        });
        const user = await this.userRepository.findOne({ where: { email } });
        if (!user)
            throw new common_1.NotFoundException('User not found');
        let userPermissions = [];
        if (user.permissions) {
            try {
                if (typeof user.permissions === 'string') {
                    userPermissions = JSON.parse(user.permissions);
                }
                else {
                    userPermissions = user.permissions;
                }
            }
            catch (error) {
                console.error(`Error parsing permissions for user ${user.id}:`, error);
                userPermissions = [];
            }
        }
        await this.userActivityService.logActivity({
            user,
            action: 'Login Verified',
            type: 'login',
            ipAddress: this.getClientIp(request),
            changedObject: `User ${user.email} successfully logged in.`,
            method: request.method,
        });
        const tokenPayload = {
            sub: user.id,
            email: user.email,
            role: user.role,
            permissions: userPermissions
        };
        const accessToken = this.generateAccessToken(tokenPayload);
        const refreshToken = this.generateRefreshToken(tokenPayload);
        return {
            user: {
                id: user.id,
                email: user.email,
                firstName: user.firstName,
                lastName: user.lastName,
                role: user.role,
                permissions: userPermissions
            },
            accessToken,
            refreshToken
        };
    }
    getRoleIdFromName(roleName) {
        const roleMap = {
            'Admin': '1',
            'Retention': '2',
            'Reactivation': '3',
            'Owner': '4',
            'Escalator': '5',
            'Agent': '6',
            'Team Lead': '7'
        };
        return roleMap[roleName] || '1';
    }
    generateAccessToken(payload) {
        return this.jwtService.sign(payload, {
            expiresIn: '10d',
        });
    }
    generateRefreshToken(payload) {
        return this.jwtService.sign(payload, {
            expiresIn: '7d'
        });
    }
};
exports.LoginService = LoginService;
exports.LoginService = LoginService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(login_entity_1.Login)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        email_service_1.EmailService,
        jwt_1.JwtService,
        user_activity_service_1.UserActivityService,
        permissions_service_1.PermissionsService])
], LoginService);
//# sourceMappingURL=login.service.js.map