import { Repository } from 'typeorm';
import { JwtTokenActivity } from '../entities/jwt-token-activity.entity';
import { Request } from 'express';
export declare class JwtTokenActivityService {
    private jwtTokenActivityRepository;
    private readonly logger;
    constructor(jwtTokenActivityRepository: Repository<JwtTokenActivity>);
    private logTokenExpiration;
    logTokenActivity(token: string, userId: number, req: Request): Promise<void>;
    updateTokenLastUsed(token: string): Promise<void>;
    invalidateToken(token: string): Promise<void>;
    markTokenAsExpired(token: string): Promise<void>;
    cleanupExpiredTokens(): Promise<void>;
    getTokenActivities(userId: number, limit?: number, offset?: number): Promise<{
        data: {
            duration_minutes: number;
            time_until_expiry: number;
            id: number;
            token: string;
            expiresAt: Date;
            isValid: boolean;
            lastUsedAt: Date;
            ipAddress: string;
            userAgent: string;
            isExpired: boolean;
            user: import("../../users/entities/user.entity").User;
            user_id: number;
            createdAt: Date;
        }[];
        total: number;
        limit: number;
        offset: number;
    }>;
}
