"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PermissionsGuard_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionsGuard = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
let PermissionsGuard = PermissionsGuard_1 = class PermissionsGuard {
    reflector;
    logger = new common_1.Logger(PermissionsGuard_1.name);
    constructor(reflector) {
        this.reflector = reflector;
    }
    canActivate(context) {
        const requiredPermission = this.reflector.get('permission', context.getHandler());
        if (!requiredPermission) {
            return true;
        }
        const request = context.switchToHttp().getRequest();
        const user = request.user;
        this.logger.debug(`Required permission: ${requiredPermission}`);
        this.logger.debug(`User role: ${user?.role}`);
        this.logger.debug(`User permissions: ${JSON.stringify(user?.permissions)}`);
        if (user?.role === 'Admin' || user?.role === 'Owner') {
            this.logger.debug('Bypassing permission check for Admin/Owner user');
            return true;
        }
        if (!user || !user.permissions) {
            this.logger.error('User or permissions not found in token');
            throw new common_1.ForbiddenException('User permissions not found in token');
        }
        const requiredCodename = requiredPermission
            .toLowerCase()
            .replace(/\s+/g, '_')
            .replace(/^can_/, '');
        let hasPermission = user.permissions.some((perm) => {
            const matchesName = perm.name === requiredPermission;
            const matchesCodename = perm.codename === requiredCodename || perm.codename === `can_${requiredCodename}`;
            this.logger.debug(`Checking permission: ${perm.name} (codename: ${perm.codename}, content_type: ${perm.content_type}) - MatchesName: ${matchesName}, MatchesCodename: ${matchesCodename}`);
            return matchesName || matchesCodename;
        });
        if (!hasPermission && requiredPermission === 'Can view employees') {
            hasPermission = user.permissions.some((perm) => {
                const matchesName = perm.name === 'Can change Assigned To';
                const matchesCodename = perm.codename === 'can_change_assigned_to';
                return matchesName || matchesCodename;
            });
        }
        if (!hasPermission) {
            this.logger.error(`User lacks required permission: ${requiredPermission}`);
            throw new common_1.ForbiddenException(`User lacks required permission: ${requiredPermission}`);
        }
        if (requiredPermission === 'Can view employees') {
            request['requestingUser'] = user;
        }
        return true;
    }
};
exports.PermissionsGuard = PermissionsGuard;
exports.PermissionsGuard = PermissionsGuard = PermissionsGuard_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.Reflector])
], PermissionsGuard);
//# sourceMappingURL=permissions.guard.js.map