import { JwtService } from '@nestjs/jwt';
import { JwtTokenActivityService } from './services/jwt-token-activity.service';
import { Request } from 'express';
export declare class AuthService {
    private jwtService;
    private jwtTokenActivityService;
    private readonly logger;
    constructor(jwtService: JwtService, jwtTokenActivityService: JwtTokenActivityService);
    validateToken(token: string, req: Request): Promise<{
        isValid: boolean;
        user: {
            id: any;
            email: any;
            role: any;
            permissions: any;
        };
    }>;
    invalidateToken(token: string): Promise<{
        message: string;
    }>;
}
