import { Controller, Post, Body, Req, Res } from '@nestjs/common';
import { LoginService } from './login.service';
import { Request, Response } from 'express';

@Controller('/api/core')
export class LoginController {
  constructor(private readonly loginService: LoginService) {}

  @Post('/generate_otp')
  async generateOTP(
    @Req() request: Request,
    @Res() response: Response,
    @Body('email') email: string,
  ) {
    const result = await this.loginService.requestOTP(email, request);
    return response.status(200).json(result);
  }

  @Post('/login')
  async login(
    @Req() request: Request,
    @Res() response: Response,
    @Body('email') email: string,
    @Body('otp') otp: string,
  ) {
    const result = await this.loginService.verifyOTP(email, otp, request);

    // Set session on success
    request.session.user = {
      email,
      loginTime: new Date().toISOString(),
    };

    return response.status(200).json({
      data: {
        name: `${result.user.firstName}_${result.user.lastName}`,
        email: result.user.email,
        role: result.user.role,
        tokens: {
          refresh: result.refreshToken,
          access: result.accessToken
        },
        permissions: result.user.permissions || []
      },
      success: true,
      message: 'Logged in Successfully',
      status: 200
    });
  }
}
