"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const product_entity_1 = require("./entities/product.entity");
let ProductsService = class ProductsService {
    productsRepository;
    constructor(productsRepository) {
        this.productsRepository = productsRepository;
    }
    async create(createProductDto) {
        try {
            const existingProduct = await this.productsRepository.findOne({
                where: { name: createProductDto.name },
            });
            if (existingProduct) {
                throw new common_1.ConflictException(`Product with name "${createProductDto.name}" already exists`);
            }
            const product = this.productsRepository.create(createProductDto);
            return await this.productsRepository.save(product);
        }
        catch (error) {
            if (error instanceof common_1.ConflictException) {
                throw error;
            }
            throw new common_1.BadRequestException(`Failed to create product: ${error.message}`);
        }
    }
    async findAll(listProductsDto) {
        const { page = 1, limit = 10, search, isActive } = listProductsDto;
        const skip = (page - 1) * limit;
        const queryBuilder = this.productsRepository.createQueryBuilder('product');
        if (search) {
            queryBuilder.where('(product.name LIKE :search OR product.description LIKE :search)', { search: `%${search}%` });
        }
        if (isActive !== undefined) {
            if (search) {
                queryBuilder.andWhere('product.isActive = :isActive', { isActive });
            }
            else {
                queryBuilder.where('product.isActive = :isActive', { isActive });
            }
        }
        queryBuilder.skip(skip).take(limit).orderBy('product.createdAt', 'DESC');
        const [data, total] = await queryBuilder.getManyAndCount();
        return { data, total };
    }
    async findOne(id) {
        const product = await this.productsRepository.findOne({
            where: { id },
        });
        if (!product) {
            throw new common_1.NotFoundException(`Product with ID ${id} not found`);
        }
        return product;
    }
    async update(id, updateProductDto) {
        const product = await this.findOne(id);
        if (updateProductDto.name && updateProductDto.name !== product.name) {
            const existingProduct = await this.productsRepository.findOne({
                where: { name: updateProductDto.name },
            });
            if (existingProduct) {
                throw new common_1.ConflictException(`Product with name "${updateProductDto.name}" already exists`);
            }
        }
        Object.assign(product, updateProductDto);
        return await this.productsRepository.save(product);
    }
    async remove(id) {
        const product = await this.findOne(id);
        await this.productsRepository.remove(product);
    }
    async seedProducts() {
        try {
            const existingProducts = await this.productsRepository.count();
            if (existingProducts === 0) {
                const defaultProducts = [
                    {
                        name: 'Premium CRM License',
                        description: 'Full-featured CRM license with unlimited users and advanced analytics',
                    },
                    {
                        name: 'Basic CRM Package',
                        description: 'Entry-level CRM package with essential features for small teams',
                    },
                    {
                        name: 'Enterprise Support Plan',
                        description: '24/7 priority support with dedicated account manager',
                    },
                    {
                        name: 'Data Migration Service',
                        description: 'Professional data migration service from legacy systems',
                    },
                    {
                        name: 'Custom Integration Package',
                        description: 'Tailored integration solutions for third-party applications',
                    },
                ];
                for (const productData of defaultProducts) {
                    const existing = await this.productsRepository.findOne({
                        where: { name: productData.name },
                    });
                    if (!existing) {
                        await this.productsRepository.save(productData);
                    }
                }
            }
        }
        catch (error) {
            console.warn('Products seeding skipped - table may not exist yet:', error.message);
        }
    }
};
exports.ProductsService = ProductsService;
exports.ProductsService = ProductsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ProductsService);
//# sourceMappingURL=products.service.js.map