"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDatabaseConfig = void 0;
const typeorm_1 = require("typeorm");
const mysql = require("mysql2/promise");
const getDatabaseConfig = async (configService) => {
    const config = {
        type: 'mysql',
        host: configService.get('DB_HOST'),
        port: configService.get('DB_PORT'),
        username: configService.get('DB_USERNAME'),
        password: configService.get('DB_PASSWORD'),
        database: configService.get('DB_DATABASE'),
        entities: [__dirname + '/../**/*.entity{.ts,.js}'],
        synchronize: configService.get('DB_SYNCHRONIZE') === 'true',
        logging: configService.get('NODE_ENV') === 'development' ? ['query', 'error'] : ['error'],
        logger: 'advanced-console',
        namingStrategy: new typeorm_1.DefaultNamingStrategy(),
    };
    if (configService.get('DB_SYNCHRONIZE') === 'true') {
        try {
            const connection = await mysql.createConnection({
                host: configService.get('DB_HOST'),
                port: configService.get('DB_PORT'),
                user: configService.get('DB_USERNAME'),
                password: configService.get('DB_PASSWORD'),
                database: configService.get('DB_DATABASE'),
            });
            await connection.execute(`
        DELETE oi FROM order_items oi
        INNER JOIN orders o ON oi.orderId = o.id
        LEFT JOIN customers c ON o.customerId = c.id
        WHERE o.customerId IS NOT NULL 
        AND c.id IS NULL
      `);
            await connection.execute(`
        DELETE o FROM orders o
        LEFT JOIN customers c ON o.customerId = c.id
        WHERE o.customerId IS NOT NULL 
        AND c.id IS NULL
      `);
            await connection.execute(`
        UPDATE orders 
        SET orderNumber = CONCAT('ORD-', DATE_FORMAT(created_at, '%Y%m%d'), '-', LPAD(id, 4, '0'))
        WHERE (orderNumber IS NULL OR orderNumber = '')
      `);
            await connection.end();
            console.log('Pre-sync cleanup completed: Invalid orders removed and empty order numbers fixed');
        }
        catch (error) {
            console.warn('Pre-sync cleanup skipped (this is normal on first run):', error.message);
        }
    }
    return config;
};
exports.getDatabaseConfig = getDatabaseConfig;
//# sourceMappingURL=database.config.js.map