"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var AuthService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const jwt_token_activity_service_1 = require("./services/jwt-token-activity.service");
let AuthService = AuthService_1 = class AuthService {
    jwtService;
    jwtTokenActivityService;
    logger = new common_1.Logger(AuthService_1.name);
    constructor(jwtService, jwtTokenActivityService) {
        this.jwtService = jwtService;
        this.jwtTokenActivityService = jwtTokenActivityService;
    }
    async validateToken(token, req) {
        try {
            const payload = await this.jwtService.verifyAsync(token);
            const tokenActivity = await this.jwtTokenActivityService.updateTokenLastUsed(token);
            this.logger.debug(`Token validated for user ${payload.sub}. Token: ${token.substring(0, 10)}...`);
            return {
                isValid: true,
                user: {
                    id: payload.sub,
                    email: payload.email,
                    role: payload.role,
                    permissions: payload.permissions || []
                },
            };
        }
        catch (error) {
            this.logger.error(`Token validation failed: ${error.message}`);
            await this.jwtTokenActivityService.markTokenAsExpired(token);
            throw new common_1.UnauthorizedException('Invalid or expired token');
        }
    }
    async invalidateToken(token) {
        try {
            await this.jwtTokenActivityService.invalidateToken(token);
            this.logger.debug(`Token invalidated: ${token.substring(0, 10)}...`);
            return { message: 'Token invalidated successfully' };
        }
        catch (error) {
            this.logger.error(`Failed to invalidate token: ${error.message}`);
            throw new common_1.UnauthorizedException('Failed to invalidate token');
        }
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = AuthService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [jwt_1.JwtService,
        jwt_token_activity_service_1.JwtTokenActivityService])
], AuthService);
//# sourceMappingURL=auth.service.js.map