import { Injectable, NotFoundException } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Role } from './entities/role.entity';
import { PermissionsService } from '../permissions/permissions.service';
import { RolesResponse, RoleWithPermissions } from './roles.model';

@Injectable()
export class RolesService {
  constructor(
    @InjectRepository(Role)
    private readonly roleRepository: Repository<Role>,
    private readonly permissionsService: PermissionsService,
  ) {}

  async findAll(): Promise<RolesResponse> {
    const roles = await this.roleRepository.find();
    
    const rolesWithPermissions = await Promise.all(
      roles.map(async (role) => {
        const permissionsResponse = await this.permissionsService.findAll(role.id.toString());
        return {
          id: role.id,
          name: role.name,
          permissions: permissionsResponse.data
        };
      })
    );

    return {
      data: rolesWithPermissions,
      success: true,
      message: 'List Successfully Retrieved!',
      status: 200
    };
  }

  async findOne(id: number): Promise<Role> {
    const role = await this.roleRepository.findOne({ where: { id } });
    if (!role) {
      throw new NotFoundException(`Role with ID ${id} not found`);
    }
    return role;
  }
} 