import { Controller, Get, Query, UseGuards, Req } from '@nestjs/common';
import { JwtTokenActivityService } from '../services/jwt-token-activity.service';
import { JwtAuthGuard } from '../guards/jwt-auth.guard';
import { Request } from 'express';

@Controller('api/core/token-activities')
@UseGuards(JwtAuthGuard)
export class JwtTokenActivityController {
  constructor(private readonly jwtTokenActivityService: JwtTokenActivityService) {}

  @Get()
  async getTokenActivities(
    @Query('user__id') userId: number,
    @Query('limit') limit: number = 10,
    @Query('offset') offset: number = 0,
  ) {
    return this.jwtTokenActivityService.getTokenActivities(
      Number(userId),
      Number(limit),
      Number(offset),
    );
  }
} 