"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UsersController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersController = void 0;
const common_1 = require("@nestjs/common");
const users_service_1 = require("./users.service");
const create_user_dto_1 = require("./dto/create-user.dto");
const update_user_dto_1 = require("./dto/update-user.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_decorator_1 = require("../auth/decorators/roles.decorator");
const require_permission_decorator_1 = require("../auth/decorators/require-permission.decorator");
const roles_model_1 = require("../roles/roles.model");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
let UsersController = UsersController_1 = class UsersController {
    usersService;
    logger = new common_1.Logger(UsersController_1.name);
    constructor(usersService) {
        this.usersService = usersService;
    }
    async create(createUserDto, req) {
        this.logger.debug(`Creating new user with DTO: ${JSON.stringify(createUserDto)}`);
        return this.usersService.create(createUserDto, req.user.id);
    }
    async findAll(limit, offset, search, isActive, req) {
        const parsedLimit = limit ? parseInt(limit, 10) : 10;
        const parsedOffset = offset ? parseInt(offset, 10) : 0;
        const parsedIsActive = isActive === 'true' ? true : isActive === 'false' ? false : undefined;
        if (isNaN(parsedLimit) || isNaN(parsedOffset)) {
            throw new common_1.BadRequestException('Limit and offset must be valid numbers');
        }
        this.logger.debug(`Fetching users with limit=${parsedLimit}, offset=${parsedOffset}, search=${search}, isActive=${parsedIsActive}`);
        return this.usersService.findAll(parsedLimit, parsedOffset, search, parsedIsActive, req.requestingUser);
    }
    async findDeactivatedUsers(req) {
        this.logger.debug('Fetching deactivated users');
        return this.usersService.findDeactivatedUsers(req.user, req.ip);
    }
    async findOne(id, req) {
        this.logger.debug(`Fetching user with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.findOne(parsedId, req.requestingUser);
    }
    async update(id, updateUserDto, req) {
        this.logger.debug(`Updating user with ID ${id} with DTO: ${JSON.stringify(updateUserDto)}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.update(parsedId, updateUserDto);
    }
    async reactivate(id, req) {
        this.logger.debug(`Reactivating user with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.reactivate(parsedId);
    }
    async deactivate(id, req) {
        this.logger.debug(`Deactivating user with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.deactivate(parsedId);
    }
    async remove(id, req) {
        this.logger.debug(`Deleting user with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.remove(parsedId);
    }
    async bulkCreate(file, req) {
        this.logger.debug(`Bulk creating users from file: ${file?.originalname}`);
        if (!file) {
            throw new common_1.BadRequestException('File is required');
        }
        return this.usersService.bulkCreate(file);
    }
    async createAssign(createUserDto, req) {
        this.logger.debug(`Creating new user (assignemployees) with DTO: ${JSON.stringify(createUserDto)}`);
        return this.usersService.create(createUserDto, req.user.id);
    }
    async findAllAssign(limit, offset, search, isActive, req) {
        const parsedLimit = limit ? parseInt(limit, 10) : 10;
        const parsedOffset = offset ? parseInt(offset, 10) : 0;
        const parsedIsActive = isActive === 'true' ? true : isActive === 'false' ? false : undefined;
        if (isNaN(parsedLimit) || isNaN(parsedOffset)) {
            throw new common_1.BadRequestException('Limit and offset must be valid numbers');
        }
        this.logger.debug(`Fetching users (assignemployees) with limit=${parsedLimit}, offset=${parsedOffset}, search=${search}, isActive=${parsedIsActive}`);
        return this.usersService.findAll(parsedLimit, parsedOffset, search, parsedIsActive, req.requestingUser);
    }
    async findDeactivatedAssign(req) {
        this.logger.debug('Fetching deactivated users (assignemployees)');
        return this.usersService.findDeactivatedUsers(req.user, req.ip);
    }
    async findOneAssign(id, req) {
        this.logger.debug(`Fetching user (assignemployees) with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.findOne(parsedId, req.requestingUser);
    }
    async updateAssign(id, updateUserDto, req) {
        this.logger.debug(`Updating user (assignemployees) with ID ${id} with DTO: ${JSON.stringify(updateUserDto)}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.update(parsedId, updateUserDto);
    }
    async reactivateAssign(id, req) {
        this.logger.debug(`Reactivating user (assignemployees) with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.reactivate(parsedId);
    }
    async deactivateAssign(id, req) {
        this.logger.debug(`Deactivating user (assignemployees) with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.deactivate(parsedId);
    }
    async removeAssign(id, req) {
        this.logger.debug(`Deleting user (assignemployees) with ID ${id}`);
        const parsedId = parseInt(id, 10);
        if (isNaN(parsedId)) {
            throw new common_1.BadRequestException('Invalid user ID');
        }
        return this.usersService.remove(parsedId);
    }
    async bulkCreateAssign(file, req) {
        this.logger.debug(`Bulk creating users (assignemployees) from file: ${file?.originalname}`);
        if (!file) {
            throw new common_1.BadRequestException('File is required');
        }
        return this.usersService.bulkCreate(file);
    }
};
exports.UsersController = UsersController;
__decorate([
    (0, common_1.Post)('employees'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can add employees'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_user_dto_1.CreateUserDto, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('employees'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can view employees'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('offset')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('isActive')),
    __param(4, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('employees/deactivatedlist'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can view employees'),
    __param(0, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "findDeactivatedUsers", null);
__decorate([
    (0, common_1.Get)('employees/:id'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can view employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)('employees/:id'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can change employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_user_dto_1.UpdateUserDto, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "update", null);
__decorate([
    (0, common_1.Patch)('employees/:id/reactivate'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can change employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "reactivate", null);
__decorate([
    (0, common_1.Patch)('employees/:id/deactivate'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can change employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "deactivate", null);
__decorate([
    (0, common_1.Delete)('employees/:id'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can delete employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "remove", null);
__decorate([
    (0, common_1.Post)('employees/bulk'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can add employees'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', {
        storage: (0, multer_1.diskStorage)({
            destination: './uploads',
        }),
        limits: {
            fileSize: 5 * 1024 * 1024,
        },
        fileFilter: (req, file, callback) => {
            if (!file.originalname.match(/\.(xlsx|xls)$/)) {
                return callback(new common_1.BadRequestException('Only Excel files are allowed!'), false);
            }
            callback(null, true);
        },
    })),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "bulkCreate", null);
__decorate([
    (0, common_1.Post)('assignemployees'),
    (0, require_permission_decorator_1.RequirePermission)('Can change Assigned To'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_user_dto_1.CreateUserDto, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "createAssign", null);
__decorate([
    (0, common_1.Get)('assignemployees'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can view employees'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('offset')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('isActive')),
    __param(4, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "findAllAssign", null);
__decorate([
    (0, common_1.Get)('assignemployees/deactivatedlist'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can view employees'),
    __param(0, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "findDeactivatedAssign", null);
__decorate([
    (0, common_1.Get)('assignemployees/:id'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can view employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "findOneAssign", null);
__decorate([
    (0, common_1.Patch)('assignemployees/:id'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can change employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_user_dto_1.UpdateUserDto, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "updateAssign", null);
__decorate([
    (0, common_1.Patch)('assignemployees/:id/reactivate'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can change employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "reactivateAssign", null);
__decorate([
    (0, common_1.Patch)('assignemployees/:id/deactivate'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can change employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "deactivateAssign", null);
__decorate([
    (0, common_1.Delete)('assignemployees/:id'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can delete employees'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "removeAssign", null);
__decorate([
    (0, common_1.Post)('assignemployees/bulk'),
    (0, roles_decorator_1.Roles)(roles_model_1.UserRole.ADMIN, roles_model_1.UserRole.OWNER),
    (0, require_permission_decorator_1.RequirePermission)('Can add employees'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', {
        storage: (0, multer_1.diskStorage)({
            destination: './uploads',
        }),
        limits: {
            fileSize: 5 * 1024 * 1024,
        },
        fileFilter: (req, file, callback) => {
            if (!file.originalname.match(/\.(xlsx|xls)$/)) {
                return callback(new common_1.BadRequestException('Only Excel files are allowed!'), false);
            }
            callback(null, true);
        },
    })),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "bulkCreateAssign", null);
exports.UsersController = UsersController = UsersController_1 = __decorate([
    (0, common_1.Controller)('api/users'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, permissions_guard_1.PermissionsGuard),
    __metadata("design:paramtypes", [users_service_1.UsersService])
], UsersController);
//# sourceMappingURL=users.controller.js.map