"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const customer_entity_1 = require("./entities/customer.entity");
const address_entity_1 = require("./entities/address.entity");
const customer_note_entity_1 = require("./entities/customer-note.entity");
const user_entity_1 = require("../users/entities/user.entity");
let CustomersService = class CustomersService {
    customersRepository;
    addressesRepository;
    customerNotesRepository;
    usersRepository;
    constructor(customersRepository, addressesRepository, customerNotesRepository, usersRepository) {
        this.customersRepository = customersRepository;
        this.addressesRepository = addressesRepository;
        this.customerNotesRepository = customerNotesRepository;
        this.usersRepository = usersRepository;
    }
    async create(createCustomerDto, user) {
        if (!user || !user.id) {
            throw new common_1.UnauthorizedException('User must be authenticated');
        }
        const { email, first_name, last_name, home_phone, mobile_phone, address, title, iso, DNC, is_land_line_default, assigned_to_id } = createCustomerDto;
        if (email) {
            const existingCustomer = await this.customersRepository.findOne({ where: { email } });
            if (existingCustomer) {
                throw new common_1.ConflictException('Email already exists');
            }
        }
        if (assigned_to_id) {
            const assignee = await this.usersRepository.findOne({ where: { id: parseInt(assigned_to_id.toString(), 10) } });
            if (!assignee) {
                throw new common_1.NotFoundException(`User with ID ${assigned_to_id} not found`);
            }
        }
        const customer = this.customersRepository.create({
            firstName: first_name,
            lastName: last_name,
            email,
            mobileNumber: mobile_phone,
            landline: home_phone,
            title,
            iso,
            dnc: DNC,
            isLandLineDefault: is_land_line_default,
            assigned_to_id: assigned_to_id ? parseInt(assigned_to_id.toString(), 10) : user.id,
            createdById: user.id,
        });
        const savedCustomer = await this.customersRepository.save(customer);
        if (address && address.length > 0) {
            const addresses = address.map((addr) => this.addressesRepository.create({
                ...addr,
                customer: savedCustomer,
                isActive: true,
            }));
            await this.addressesRepository.save(addresses);
            savedCustomer.addresses = addresses;
        }
        return savedCustomer;
    }
    async update(id, updateCustomerDto, user) {
        if (!user || !user.id) {
            throw new common_1.UnauthorizedException('User must be authenticated');
        }
        console.log(`Updating customer with ID: ${id}`);
        const customer = await this.customersRepository.findOne({ where: { id }, relations: ['addresses'] });
        if (!customer) {
            throw new common_1.NotFoundException(`Customer with ID ${id} not found`);
        }
        const roleName = typeof user.role === 'string' ? user.role : user.role?.name || '';
        if (customer.assigned_to_id !== user.id && customer.createdById !== user.id && roleName.toLowerCase() !== 'admin' && roleName.toLowerCase() !== 'owner') {
            throw new common_1.UnauthorizedException('Not authorized to update this customer');
        }
        if (updateCustomerDto.email && updateCustomerDto.email !== customer.email) {
            const existingCustomer = await this.customersRepository.findOne({ where: { email: updateCustomerDto.email } });
            if (existingCustomer) {
                throw new common_1.ConflictException('Email already exists');
            }
        }
        if (updateCustomerDto.gen_customer_id && updateCustomerDto.gen_customer_id !== customer.genCustomerId) {
            const existingCustomer = await this.customersRepository.findOne({ where: { genCustomerId: updateCustomerDto.gen_customer_id } });
            if (existingCustomer) {
                throw new common_1.ConflictException('Generated customer ID already exists');
            }
        }
        if (updateCustomerDto.assigned_to_id) {
            const assignee = await this.usersRepository.findOne({ where: { id: parseInt(updateCustomerDto.assigned_to_id.toString(), 10) } });
            if (!assignee) {
                throw new common_1.NotFoundException(`User with ID ${updateCustomerDto.assigned_to_id} not found`);
            }
        }
        const updatedCustomer = this.customersRepository.merge(customer, {
            firstName: updateCustomerDto.first_name,
            lastName: updateCustomerDto.last_name,
            email: updateCustomerDto.email,
            mobileNumber: updateCustomerDto.mobile_phone,
            landline: updateCustomerDto.home_phone,
            title: updateCustomerDto.title,
            iso: updateCustomerDto.iso,
            dnc: updateCustomerDto.DNC,
            isLandLineDefault: updateCustomerDto.is_land_line_default,
            isActive: updateCustomerDto.is_active,
            customerId: updateCustomerDto.customer_id,
            genCustomerId: updateCustomerDto.gen_customer_id,
            assigned_to_id: updateCustomerDto.assigned_to_id ? parseInt(updateCustomerDto.assigned_to_id.toString(), 10) : customer.assigned_to_id,
        });
        const savedCustomer = await this.customersRepository.save(updatedCustomer);
        if (updateCustomerDto.address) {
            const existingAddresses = customer.addresses || [];
            const updatedAddressIds = updateCustomerDto.address
                .filter((addr) => addr.id)
                .map((addr) => addr.id);
            for (const existingAddress of existingAddresses) {
                if (!updatedAddressIds.includes(existingAddress.id)) {
                    existingAddress.isActive = false;
                    await this.addressesRepository.save(existingAddress);
                }
            }
            const addresses = await Promise.all(updateCustomerDto.address.map(async (addr) => {
                if (addr.id) {
                    const existingAddress = existingAddresses.find((ea) => ea.id === addr.id);
                    if (existingAddress) {
                        return this.addressesRepository.merge(existingAddress, {
                            ...addr,
                            isActive: addr.is_active !== undefined ? addr.is_active : existingAddress.isActive,
                        });
                    }
                }
                return this.addressesRepository.create({
                    ...addr,
                    customer: savedCustomer,
                    isActive: addr.is_active !== undefined ? addr.is_active : true,
                });
            }));
            await this.addressesRepository.save(addresses);
            savedCustomer.addresses = addresses;
        }
        return savedCustomer;
    }
    async updateById(id, updateCustomerDto, user) {
        if (!user || !user.id) {
            throw new common_1.UnauthorizedException('User must be authenticated');
        }
        console.log(`Updating customer with id: ${id}`);
        const customer = await this.customersRepository.findOne({ where: { id }, relations: ['addresses'] });
        if (!customer) {
            throw new common_1.NotFoundException(`Customer with id ${id} not found`);
        }
        const roleName = typeof user.role === 'string' ? user.role : user.role?.name || '';
        if (customer.assigned_to_id !== user.id && customer.createdById !== user.id && roleName.toLowerCase() !== 'admin' && roleName.toLowerCase() !== 'owner') {
            throw new common_1.UnauthorizedException('Not authorized to update this customer');
        }
        if (updateCustomerDto.email && updateCustomerDto.email !== customer.email) {
            const existingCustomer = await this.customersRepository.findOne({ where: { email: updateCustomerDto.email } });
            if (existingCustomer) {
                throw new common_1.ConflictException('Email already exists');
            }
        }
        if (updateCustomerDto.gen_customer_id && updateCustomerDto.gen_customer_id !== customer.genCustomerId) {
            const existingCustomer = await this.customersRepository.findOne({ where: { genCustomerId: updateCustomerDto.gen_customer_id } });
            if (existingCustomer) {
                throw new common_1.ConflictException('Generated customer ID already exists');
            }
        }
        if (updateCustomerDto.assigned_to_id) {
            const assignee = await this.usersRepository.findOne({ where: { id: parseInt(updateCustomerDto.assigned_to_id.toString(), 10) } });
            if (!assignee) {
                throw new common_1.NotFoundException(`User with ID ${updateCustomerDto.assigned_to_id} not found`);
            }
        }
        const updatedCustomer = this.customersRepository.merge(customer, {
            firstName: updateCustomerDto.first_name,
            lastName: updateCustomerDto.last_name,
            email: updateCustomerDto.email,
            mobileNumber: updateCustomerDto.mobile_phone,
            landline: updateCustomerDto.home_phone,
            title: updateCustomerDto.title,
            iso: updateCustomerDto.iso,
            dnc: updateCustomerDto.DNC,
            isLandLineDefault: updateCustomerDto.is_land_line_default,
            isActive: updateCustomerDto.is_active,
            customerId: updateCustomerDto.customer_id,
            genCustomerId: updateCustomerDto.gen_customer_id,
            assigned_to_id: updateCustomerDto.assigned_to_id ? parseInt(updateCustomerDto.assigned_to_id.toString(), 10) : customer.assigned_to_id,
        });
        if (updateCustomerDto.address) {
            const existingAddresses = customer.addresses || [];
            const updatedAddressIds = updateCustomerDto.address
                .filter((addr) => addr.id)
                .map((addr) => addr.id);
            for (const existingAddress of existingAddresses) {
                if (!updatedAddressIds.includes(existingAddress.id)) {
                    existingAddress.isActive = false;
                    await this.addressesRepository.save(existingAddress);
                }
            }
            const addresses = await Promise.all(updateCustomerDto.address.map(async (addr) => {
                if (addr.id) {
                    const existingAddress = existingAddresses.find((ea) => ea.id === addr.id);
                    if (existingAddress) {
                        return this.addressesRepository.merge(existingAddress, {
                            ...addr,
                            isActive: addr.is_active !== undefined ? addr.is_active : existingAddress.isActive,
                        });
                    }
                }
                return this.addressesRepository.create({
                    ...addr,
                    customer: updatedCustomer,
                    isActive: addr.is_active !== undefined ? addr.is_active : true,
                });
            }));
            updatedCustomer.addresses = addresses;
        }
        return this.customersRepository.save(updatedCustomer);
    }
    async findOne(id, user) {
        if (!user || !user.id) {
            throw new common_1.UnauthorizedException('User must be authenticated');
        }
        const customer = await this.customersRepository.findOne({
            where: { id },
            relations: ['addresses', 'assignedTo', 'assignedTo.reportsTo'],
        });
        if (!customer) {
            throw new common_1.NotFoundException(`Customer with ID ${id} not found`);
        }
        const roleName = typeof user.role === 'string' ? user.role : user.role || '';
        if (customer.assigned_to_id !== user.id && customer.createdById !== user.id && roleName.toLowerCase() !== 'admin' && roleName.toLowerCase() !== 'owner') {
            throw new common_1.UnauthorizedException('Not authorized to view this customer');
        }
        const notes = await this.customerNotesRepository.find({
            where: { customer: { id } },
            relations: ['parentNote'],
            order: { createdAt: 'DESC' },
        });
        const creator = await this.usersRepository.findOne({ where: { id: customer.createdById } });
        const transformedNotes = notes.map(note => ({
            id: note.id,
            replies: [],
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            total_parents_count: 0,
            created_at: note.createdAt,
            updated_at: note.updatedAt,
            is_active: true,
            note: note.note,
            customer: customer.id,
            parent_note: note.parentNote ? note.parentNote.id : null,
            child_note: null,
        }));
        return {
            id: customer.id,
            customer_notes: transformedNotes,
            address: customer.addresses || [],
            assigned_to: customer.assignedTo ? {
                id: customer.assignedTo.id,
                user: {
                    email: customer.assignedTo.email || '',
                    name: `${customer.assignedTo.firstName || ''} ${customer.assignedTo.lastName || ''}`.trim() || customer.assignedTo.email || '',
                    last_login: customer.assignedTo.lastLogin || null,
                },
                granted_permissions: customer.assignedTo.permissions || [],
                role: {
                    id: '',
                    name: customer.assignedTo.role || '',
                    permissions: [],
                },
                reports_to: customer.assignedTo.reportsTo ? customer.assignedTo.reportsTo.id : null,
                created_at: customer.assignedTo.createdAt || null,
                updated_at: customer.assignedTo.updatedAt || null,
                is_active: customer.assignedTo.isActive ?? true,
            } : null,
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            created_at: customer.createdAt,
            updated_at: customer.updatedAt,
            is_active: customer.isActive,
            customer_id: customer.customerId,
            gen_customer_id: customer.genCustomerId,
            title: customer.title,
            first_name: customer.firstName,
            last_name: customer.lastName,
            email: customer.email,
            mobile_phone: customer.dnc === true ? 'DNC' : customer.mobileNumber || '',
            home_phone: customer.dnc === true ? 'DNC' : customer.landline || '',
            is_land_line_default: customer.isLandLineDefault,
            iso: customer.iso,
            DNC: customer.dnc,
        };
    }
    async findOneByCustomerId(customerId, user) {
        if (!user || !user.id) {
            throw new common_1.UnauthorizedException('User must be authenticated');
        }
        console.log(`Querying customer with customer_id: ${customerId} (type: ${typeof customerId}) for user ID: ${user.id}`);
        const customer = await this.customersRepository.findOne({
            where: { customerId: customerId.toString() },
            relations: ['addresses', 'assignedTo', 'assignedTo.reportsTo'],
        });
        if (!customer) {
            console.error(`No customer found with customer_id: ${customerId}`);
            throw new common_1.NotFoundException(`Customer with customer_id ${customerId} not found`);
        }
        const roleName = typeof user.role === 'string' ? user.role : user.role?.name || '';
        console.log(`User role: ${roleName}, assigned_to_id: ${customer.assigned_to_id}, createdById: ${customer.createdById}, user.id: ${user.id}`);
        if (customer.assigned_to_id !== user.id && customer.createdById !== user.id && roleName.toLowerCase() !== 'admin' && roleName.toLowerCase() !== 'owner') {
            console.error(`User ${user.id} not authorized to view customer ${customerId}`);
            throw new common_1.UnauthorizedException('Not authorized to view this customer');
        }
        const notes = await this.customerNotesRepository.find({
            where: { customer: { id: customer.id } },
            relations: ['parentNote'],
            order: { createdAt: 'DESC' },
        });
        const creator = await this.usersRepository.findOne({ where: { id: customer.createdById } });
        const transformedNotes = notes.map(note => ({
            id: note.id,
            replies: [],
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            total_parents_count: 0,
            created_at: note.createdAt,
            updated_at: note.updatedAt,
            is_active: true,
            note: note.note,
            customer: customer.id,
            parent_note: note.parentNote ? note.parentNote.id : null,
            child_note: null,
        }));
        return {
            id: customer.id,
            customer_notes: transformedNotes,
            address: customer.addresses || [],
            assigned_to: customer.assignedTo ? {
                id: customer.assignedTo.id,
                user: {
                    email: customer.assignedTo.email || '',
                    name: `${customer.assignedTo.firstName || ''} ${customer.assignedTo.lastName || ''}`.trim() || customer.assignedTo.email || '',
                    last_login: customer.assignedTo.lastLogin || null,
                },
                granted_permissions: customer.assignedTo.permissions || [],
                role: {
                    id: '',
                    name: customer.assignedTo.role || '',
                    permissions: [],
                },
                reports_to: customer.assignedTo.reportsTo ? customer.assignedTo.reportsTo.id : null,
                created_at: customer.assignedTo.createdAt || null,
                updated_at: customer.assignedTo.updatedAt || null,
                is_active: customer.assignedTo.isActive ?? true,
            } : null,
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            created_at: customer.createdAt,
            updated_at: customer.updatedAt,
            is_active: customer.isActive,
            customer_id: customer.customerId,
            gen_customer_id: customer.genCustomerId,
            title: customer.title,
            first_name: customer.firstName,
            last_name: customer.lastName,
            email: customer.email,
            mobile_phone: customer.dnc === true ? 'DNC' : customer.mobileNumber || '',
            home_phone: customer.dnc === true ? 'DNC' : customer.landline || '',
            is_land_line_default: customer.isLandLineDefault,
            iso: customer.iso,
            DNC: customer.dnc,
        };
    }
    async findAll(listCustomersDto, user) {
        if (!user || !user.id) {
            throw new common_1.UnauthorizedException('User must be authenticated');
        }
        const { offset = 0, limit = 10, search, scope } = listCustomersDto;
        const roleName = typeof user.role === 'string' ? user.role : user.role?.name || '';
        const qb = this.customersRepository.createQueryBuilder('customer')
            .leftJoinAndSelect('customer.addresses', 'addresses')
            .leftJoinAndSelect('customer.assignedTo', 'assignedTo')
            .leftJoinAndSelect('assignedTo.reportsTo', 'reportsTo')
            .skip(offset)
            .take(limit)
            .orderBy('customer.createdAt', 'DESC');
        if (roleName.toLowerCase() !== 'admin' && roleName.toLowerCase() !== 'owner') {
            qb.andWhere('(customer.assigned_to_id = :userId OR customer.createdById = :userId)', { userId: user.id });
        }
        const fieldMap = {
            first_name: 'customer.firstName',
            last_name: 'customer.lastName',
            email: 'customer.email',
            mobile_phone: 'customer.mobileNumber',
            home_phone: 'customer.landline',
            id: 'customer.id',
        };
        if (scope === 'created_by') {
            qb.andWhere('customer.createdById = :createdById', { createdById: user.id });
        }
        else if (scope && !fieldMap[scope]) {
            qb.andWhere('customer.iso = :iso', { iso: scope });
        }
        if (search) {
            if (scope && fieldMap[scope]) {
                qb.andWhere(`${fieldMap[scope]} LIKE :search`, { search: `%${search}%` });
            }
            else {
                qb.andWhere([
                    'customer.firstName LIKE :search',
                    'customer.lastName LIKE :search',
                    'customer.id LIKE :search',
                    'customer.email LIKE :search',
                    'customer.mobileNumber LIKE :search',
                    'customer.landline LIKE :search',
                ].join(' OR '), { search: `%${search}%` });
            }
        }
        const [data, total] = await qb.getManyAndCount();
        const creatorIds = [...new Set(data.map(customer => customer.createdById))];
        const creators = await this.usersRepository.find({ where: { id: (0, typeorm_2.In)(creatorIds) } });
        const creatorMap = new Map(creators.map(creator => [creator.id, creator]));
        const transformedData = data.map(customer => ({
            id: customer.id,
            first_name: customer.firstName,
            last_name: customer.lastName,
            email: customer.email,
            mobile_phone: customer.dnc === true ? 'DNC' : customer.mobileNumber || '',
            home_phone: customer.dnc === true ? 'DNC' : customer.landline || '',
            address: customer.addresses || [],
            title: customer.title,
            iso: customer.iso,
            DNC: customer.dnc,
            is_land_line_default: customer.isLandLineDefault,
            created_at: customer.createdAt,
            customer_id: customer.customerId,
            gen_customer_id: customer.genCustomerId,
            assigned_to: customer.assignedTo ? {
                id: customer.assignedTo.id,
                user: {
                    email: customer.assignedTo.email || '',
                    name: `${customer.assignedTo.firstName || ''} ${customer.assignedTo.lastName || ''}`.trim() || customer.assignedTo.email || '',
                    last_login: customer.assignedTo.lastLogin || null,
                },
                granted_permissions: customer.assignedTo.permissions || [],
                role: {
                    id: '',
                    name: customer.assignedTo.role || '',
                    permissions: [],
                },
                reports_to: customer.assignedTo.reportsTo ? customer.assignedTo.reportsTo.id : null,
                created_at: customer.assignedTo.createdAt || null,
                updated_at: customer.assignedTo.updatedAt || null,
                is_active: customer.assignedTo.isActive ?? true,
            } : null,
            created_by: {
                id: customer.createdById,
                user: {
                    email: creatorMap.get(customer.createdById)?.email || user.email,
                    name: creatorMap.get(customer.createdById) ?
                        `${creatorMap.get(customer.createdById)?.firstName || ''} ${creatorMap.get(customer.createdById)?.lastName || ''}`.trim() || user.email : user.email,
                    last_login: creatorMap.get(customer.createdById)?.lastLogin || user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: creatorMap.get(customer.createdById)?.createdAt || user.createdAt || new Date(),
                updated_at: creatorMap.get(customer.createdById)?.updatedAt || user.updatedAt || new Date(),
                is_active: creatorMap.get(customer.createdById)?.isActive ?? user.isActive,
            },
        }));
        return { data: transformedData, total };
    }
    async bulkAssign(dto, user) {
        const { customer_ids, assigned_to_id } = dto;
        if (!user || !user.id) {
            throw new common_1.UnauthorizedException('User must be authenticated');
        }
        const assignee = await this.usersRepository.findOne({ where: { id: assigned_to_id } });
        if (!assignee) {
            throw new common_1.NotFoundException(`User with ID ${assigned_to_id} not found`);
        }
        const customers = await this.customersRepository.findBy({ id: (0, typeorm_2.In)(customer_ids) });
        if (!customers.length) {
            throw new common_1.NotFoundException(`No customers found with the provided IDs`);
        }
        for (const customer of customers) {
            customer.assigned_to_id = assigned_to_id;
        }
        await this.customersRepository.save(customers);
        return `Selected customers have been assigned to ${assignee.firstName || ''}_${assignee.lastName || 'user'}`;
    }
};
exports.CustomersService = CustomersService;
exports.CustomersService = CustomersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __param(1, (0, typeorm_1.InjectRepository)(address_entity_1.Address)),
    __param(2, (0, typeorm_1.InjectRepository)(customer_note_entity_1.CustomerNote)),
    __param(3, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], CustomersService);
//# sourceMappingURL=customers.service.js.map