"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomersController = void 0;
const common_1 = require("@nestjs/common");
const customers_service_1 = require("./customers.service");
const create_customer_dto_1 = require("./dto/create-customer.dto");
const update_customer_dto_1 = require("./dto/update-customer.dto");
const list_customers_dto_1 = require("./dto/list-customers.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const require_permission_decorator_1 = require("../auth/decorators/require-permission.decorator");
const user_decorator_1 = require("../auth/decorators/user.decorator");
const bulk_assign_customer_dto_1 = require("./dto/bulk-assign-customer.dto");
let CustomersController = class CustomersController {
    customersService;
    constructor(customersService) {
        this.customersService = customersService;
    }
    async create(createCustomerDto, user) {
        const customer = await this.customersService.create(createCustomerDto, user);
        return {
            statusCode: common_1.HttpStatus.CREATED,
            message: 'Customer profile created successfully',
            data: {
                iso: customer.iso,
                title: customer.title,
                assigned_to_id: customer.assigned_to_id,
                last_name: customer.lastName,
                first_name: customer.firstName,
                email: customer.email,
                home_phone: customer.landline,
                mobile_phone: customer.mobileNumber,
                id: customer.id,
                gen_customer_id: customer.genCustomerId,
            },
        };
    }
    async findOne(id, user) {
        try {
            const customer = await this.customersService.findOne(id, user);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Customer retrieved successfully',
                data: customer,
            };
        }
        catch (error) {
            console.error(`Error retrieving customer with id ${id} for user ${user?.id || 'unknown'}:`, error.message, error.stack);
            throw error;
        }
    }
    async bulkAssignCustomers(dto, user) {
        const result = await this.customersService.bulkAssign(dto, user);
        return {
            statusCode: 200,
            success: true,
            message: {
                detail: 'Selected customers have been assigned',
            },
            data: result,
        };
    }
    async update(id, updateCustomerDto, user) {
        try {
            const customer = await this.customersService.updateById(Number(id), updateCustomerDto, user);
            return {
                statusCode: common_1.HttpStatus.OK,
                message: 'Customer profile updated successfully',
                data: {
                    iso: customer.iso,
                    title: customer.title,
                    assigned_to_id: customer.assigned_to_id,
                    last_name: customer.lastName,
                    first_name: customer.firstName,
                    email: customer.email,
                    home_phone: customer.landline,
                    mobile_phone: customer.mobileNumber,
                    id: customer.id,
                    gen_customer_id: customer.genCustomerId,
                },
            };
        }
        catch (error) {
            console.error(`Error updating customer with id ${id}:`, error.message);
            throw error;
        }
    }
    async findAll(listCustomersDto, user) {
        const { data, total } = await this.customersService.findAll(listCustomersDto, user);
        return {
            statusCode: common_1.HttpStatus.OK,
            message: 'Customers retrieved successfully',
            data,
            total,
        };
    }
};
exports.CustomersController = CustomersController;
__decorate([
    (0, common_1.Post)(),
    (0, require_permission_decorator_1.RequirePermission)('Can add customer'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_customer_dto_1.CreateCustomerDto, Object]),
    __metadata("design:returntype", Promise)
], CustomersController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, require_permission_decorator_1.RequirePermission)('Can view customer'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], CustomersController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)('bulk_assign'),
    (0, require_permission_decorator_1.RequirePermission)('Can change customer'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [bulk_assign_customer_dto_1.BulkAssignCustomerDto, Object]),
    __metadata("design:returntype", Promise)
], CustomersController.prototype, "bulkAssignCustomers", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, require_permission_decorator_1.RequirePermission)('Can change customer'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_customer_dto_1.UpdateCustomerDto, Object]),
    __metadata("design:returntype", Promise)
], CustomersController.prototype, "update", null);
__decorate([
    (0, common_1.Get)(),
    (0, require_permission_decorator_1.RequirePermission)('Can view customer'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [list_customers_dto_1.ListCustomersDto, Object]),
    __metadata("design:returntype", Promise)
], CustomersController.prototype, "findAll", null);
exports.CustomersController = CustomersController = __decorate([
    (0, common_1.Controller)('api/customer/management'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, permissions_guard_1.PermissionsGuard),
    __metadata("design:paramtypes", [customers_service_1.CustomersService])
], CustomersController);
//# sourceMappingURL=customers.controller.js.map