import { HttpStatus } from '@nestjs/common';
import { CustomersService } from './customers.service';
import { CreateCustomerDto } from './dto/create-customer.dto';
import { UpdateCustomerDto } from './dto/update-customer.dto';
import { ListCustomersDto } from './dto/list-customers.dto';
import { BulkAssignCustomerDto } from './dto/bulk-assign-customer.dto';
export declare class CustomersController {
    private readonly customersService;
    constructor(customersService: CustomersService);
    create(createCustomerDto: CreateCustomerDto, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: {
            iso: string;
            title: string;
            assigned_to_id: number | null;
            last_name: string;
            first_name: string;
            email: string;
            home_phone: string;
            mobile_phone: string;
            id: number;
            gen_customer_id: string;
        };
    }>;
    findOne(id: number, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: any;
    }>;
    bulkAssignCustomers(dto: BulkAssignCustomerDto, user: any): Promise<{
        statusCode: number;
        success: boolean;
        message: {
            detail: string;
        };
        data: string;
    }>;
    update(id: string, updateCustomerDto: UpdateCustomerDto, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: {
            iso: string;
            title: string;
            assigned_to_id: number | null;
            last_name: string;
            first_name: string;
            email: string;
            home_phone: string;
            mobile_phone: string;
            id: number;
            gen_customer_id: string;
        };
    }>;
    findAll(listCustomersDto: ListCustomersDto, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: any[];
        total: number;
    }>;
}
