"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerNotesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const customer_note_entity_1 = require("./entities/customer-note.entity");
const customer_entity_1 = require("./entities/customer.entity");
const user_entity_1 = require("../users/entities/user.entity");
let CustomerNotesService = class CustomerNotesService {
    customerNotesRepository;
    customersRepository;
    usersRepository;
    constructor(customerNotesRepository, customersRepository, usersRepository) {
        this.customerNotesRepository = customerNotesRepository;
        this.customersRepository = customersRepository;
        this.usersRepository = usersRepository;
    }
    async create(createCustomerNoteDto, user) {
        const { note, customer: customerId, parent_note: parentNoteId, child_note_id, isActive } = createCustomerNoteDto;
        try {
            const customer = await this.customersRepository.findOne({ where: { id: customerId } });
            if (!customer)
                throw new common_1.NotFoundException(`Customer with ID ${customerId} not found`);
            let parentNote = null;
            if (parentNoteId) {
                parentNote = await this.customerNotesRepository.findOne({ where: { id: parentNoteId } });
                if (!parentNote)
                    throw new common_1.NotFoundException(`Parent note with ID ${parentNoteId} not found`);
            }
            let createdBy = null;
            if (user && user.id) {
                createdBy = await this.usersRepository.findOne({ where: { id: user.id } });
                if (!createdBy)
                    throw new common_1.NotFoundException(`Created by user with ID ${user.id} not found`);
            }
            let childNote = null;
            if (child_note_id) {
                childNote = await this.customerNotesRepository.findOne({ where: { id: child_note_id } });
                if (!childNote)
                    throw new common_1.NotFoundException(`Child note with ID ${child_note_id} not found`);
            }
            const newNote = this.customerNotesRepository.create({
                note,
                customer,
                parentNote,
                childNote,
                createdBy,
                isActive: typeof isActive !== 'undefined' ? isActive : true,
            });
            const savedNote = await this.customerNotesRepository.save(newNote);
            return savedNote;
        }
        catch (error) {
            throw error;
        }
    }
    async findAll(customerId, ordering = '-created_at', limit = 10, offset = 0, user) {
        try {
            const userEntity = await this.usersRepository.findOne({ where: { id: user.id } });
            if (!userEntity)
                throw new common_1.NotFoundException(`User with ID ${user.id} not found`);
            const order = {
                createdAt: ordering === '-created_at' ? 'DESC' : 'ASC',
            };
            const [notes, total] = await this.customerNotesRepository.findAndCount({
                where: { customer: { id: customerId } },
                order,
                relations: ['parentNote', 'childNote', 'customer', 'createdBy'],
                skip: offset,
                take: limit,
            });
            const transformedNotes = notes.map(note => ({
                id: note.id,
                created_at: note.createdAt,
                updated_at: note.updatedAt,
                is_active: note.isActive,
                note: note.note,
                child_note_id: note.childNote ? note.childNote.id : null,
                created_by_id: note.createdBy ? note.createdBy.id : null,
                created_by_name: note.createdBy ? `${note.createdBy.firstName} ${note.createdBy.lastName}`.trim() : null,
                customer_id: note.customer.id,
                parent_note_id: note.parentNote ? note.parentNote.id : null,
            }));
            const baseUrl = '/api/customers/notes';
            const next = offset + limit < total
                ? `${baseUrl}?customer=${customerId}&offset=${offset + limit}&limit=${limit}&ordering=${ordering}`
                : null;
            const previous = offset > 0
                ? `${baseUrl}?customer=${customerId}&offset=${Math.max(0, offset - limit)}&limit=${limit}&ordering=${ordering}`
                : null;
            return { data: transformedNotes, count: total, next, previous };
        }
        catch (error) {
            throw error;
        }
    }
};
exports.CustomerNotesService = CustomerNotesService;
exports.CustomerNotesService = CustomerNotesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(customer_note_entity_1.CustomerNote)),
    __param(1, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __param(2, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], CustomerNotesService);
//# sourceMappingURL=customer-notes.service.js.map