import { Repository } from 'typeorm';
import { CustomerNote } from './entities/customer-note.entity';
import { Customer } from './entities/customer.entity';
import { User } from '../users/entities/user.entity';
import { CreateCustomerNoteDto } from './dto/create-customer-note.dto';
export declare class CustomerNotesService {
    private customerNotesRepository;
    private customersRepository;
    private usersRepository;
    constructor(customerNotesRepository: Repository<CustomerNote>, customersRepository: Repository<Customer>, usersRepository: Repository<User>);
    create(createCustomerNoteDto: CreateCustomerNoteDto, user: any): Promise<CustomerNote>;
    findAll(customerId: number, ordering: string | undefined, limit: number | undefined, offset: number | undefined, user: any): Promise<{
        data: any[];
        count: number;
        next: string | null;
        previous: string | null;
    }>;
}
